/*
 * Decompiled with CFR 0.152.
 */
public class GameItem {
    public static final boolean DEBUG_GITEM = false;
    public static final int MOVE_MOVING = 1;
    public static final int MOVE_PAUSE = 2;
    public static final int MOVE_STOP = 4;
    public static final int MOVE_TARGET = 16;
    public static final int MOVE_DIRECTION = 32;
    public static final int MOVE_CHASE = 64;
    public static final int ACCURACY = 100;
    public static final int ITEM_TYPE_GEM = 1;
    public static final int GITEM_TYPE_CURSOR = 1;
    public static final int OBJECT_TYPE_PAD = 0;
    public static final int OBJECT_TYPE_BALL = 1;
    public static final int OBJECT_TYPE_GEM = 2;
    public static int numItems;
    public static int maxItems;
    public static GameItem[] gameItems;
    public int itemType;
    protected int posX;
    protected int posY;
    protected int origX;
    protected int origY;
    protected int directionX;
    protected int directionY;
    protected int directionXN;
    protected int directionYN;
    protected int targetX;
    protected int targetY;
    protected int moveState;
    protected int progress;
    protected int velocity;
    protected int mass;
    protected int acceleration;
    protected int radius;
    protected int spriteId;
    public Sprite sprite;
    public byte spriteColorVariant;
    protected int data;
    protected int energy;
    protected int minEnergy;
    protected int energyBuffer;
    protected int energyCounter;
    protected int state;
    public int targetData;
    protected PlatformGraphics g;
    protected int creature;
    protected int myId;
    protected int lives;
    protected int ppEnergy;
    public boolean elastic;
    public static int[] dirTable;
    public int router;
    public int routerSpeed;
    public int lastX;
    public int lastY;
    public int progressX;
    public int progressY;
    protected int overcharge;
    protected int tCounter;
    public int effRadius;
    protected int energyGain;
    public int normalDamage;
    public int mineDamage;
    protected int tarState;
    protected int tarStateCount;
    public int bounce;
    public int bounceX;
    public int bounceY;
    public int explosion;
    public int expX;
    public int expY;
    public boolean exploded;
    public int myBonus;
    public int projectile;
    public int transformation;
    public int transIndex;
    public int shootTimeout;
    public int ghost;
    public int numActions;
    public boolean active;

    public GameItem(int n, int n2, int n3, int n4, int n5, int n6) {
        this.itemType = n;
        this.posX = n2;
        this.posY = n3;
        this.origX = 0;
        this.origY = 0;
        this.directionX = 0;
        this.directionY = 0;
        this.directionXN = 0;
        this.directionYN = 0;
        this.targetX = 0;
        this.targetY = 0;
        this.moveState = 0;
        this.velocity = 0;
        this.mass = 0;
        this.acceleration = 0;
        this.progress = 0;
        this.energy = 0;
        this.minEnergy = 0;
        this.state = 0;
        this.overcharge = 0;
        this.tCounter = 0;
        this.effRadius = 0;
        this.energyGain = 0;
        this.bounceX = 0;
        this.bounceY = 0;
        this.expX = 0;
        this.expY = 0;
        this.normalDamage = 0;
        this.mineDamage = 0;
        this.transformation = 0;
        this.energyBuffer = 0;
        this.numActions = 0;
        this.routerSpeed = 4;
        this.ghost = -1;
        this.energyCounter = -1;
        this.transIndex = -1;
        this.myBonus = -1;
        this.router = -1;
        this.data = -1;
        this.lives = -1;
        this.creature = -1;
        this.tarState = -1;
        this.tarStateCount = -1;
        this.bounce = -1;
        this.explosion = -1;
        this.projectile = -1;
        this.targetData = -1;
        this.shootTimeout = -1;
        this.ppEnergy = 100;
        this.radius = n4;
        this.spriteId = n5;
        this.spriteColorVariant = (byte)n6;
        this.elastic = false;
        this.exploded = false;
        this.active = true;
        if (dirTable == null) {
            this.genDirectionTable();
        }
        if (this.itemType == 20) {
            this.lastX = this.posX;
            this.lastY = this.posY;
            this.progressX = 0;
            this.progressY = 0;
        }
        if (this.spriteId >= 0) {
            this.sprite = new Sprite(this.spriteId);
            this.sprite.visible = true;
            if (this.spriteColorVariant > 0) {
                this.sprite.colorVariant = this.spriteColorVariant;
            }
            this.sprite.startPath(0);
            if (this.itemType < 10) {
                this.sprite.setVariant(0, Utils.randomInterval(0, this.sprite.getFramesCount(0) - 1));
            }
            Sprite.acquire(this.spriteId);
            Sprite.ensureResources();
        }
        this.myId = numItems;
        GameItem.gameItems[GameItem.numItems] = this;
        ++numItems;
    }

    public static void init(int n) {
        maxItems = n;
        gameItems = new GameItem[maxItems];
        numItems = 0;
    }

    public static void clean() {
        if (gameItems != null) {
            gameItems = null;
        }
    }

    public static void updateItems() {
        for (int i = 0; i < numItems; ++i) {
            gameItems[i].update();
        }
    }

    protected void update() {
        int n;
        int n2;
        if (!this.active) {
            return;
        }
        if (this.sprite != null) {
            this.sprite.update();
        }
        if (GameItem.flagUsed(this.moveState, 1)) {
            if (GameItem.flagUsed(this.moveState, 16)) {
                this.procesMove();
                if (this.itemType == 20) {
                    this.progressX = this.posX - this.lastX;
                    this.progressY = this.posY - this.lastY;
                    this.lastX = this.posX;
                    this.lastY = this.posY;
                }
            } else if (GameItem.flagUsed(this.moveState, 32)) {
                this.processMoveDirection();
            }
        } else {
            this.progressX = 0;
            this.progressY = 0;
        }
        if (this.itemType == 12 && this.state == -1 && !this.sprite.isPlaying()) {
            this.sprite.visible = false;
        }
        if ((this.itemType < 10 || this.itemType == 19) && this.state < 8 && this.state >= 0 && this.energyBuffer != 0) {
            --this.energyCounter;
            if (this.energyCounter == 0) {
                this.energyCounter = 4;
                if (this.energyBuffer > this.ppEnergy) {
                    this.addEnergy(this.ppEnergy, true);
                    this.energyBuffer -= this.ppEnergy;
                } else {
                    this.addEnergy(this.energyBuffer, true);
                    this.energyBuffer = 0;
                }
            }
        }
        if (this.itemType < 10 && this.overcharge != 0 && this.isAllive() && this.sprite.playingPath <= 8) {
            this.addEnergy(this.overcharge, false);
        }
        if (this.itemType == 100 && this.shootTimeout > 0) {
            --this.shootTimeout;
            if (this.shootTimeout == 0) {
                this.state = 0;
                this.stopItemMove();
                this.sprite.visible = false;
            }
        }
        if (this.itemType < 10 && this.state == 10 && !this.sprite.isPlaying()) {
            this.sprite.visible = false;
        } else if (this.itemType < 10 && this.state == 10 && this.sprite.isPlaying() && this.shootTimeout > 0) {
            --this.shootTimeout;
            if (this.shootTimeout == 0) {
                this.stopItemMove();
                this.sprite.visible = false;
            }
        }
        if (this.itemType == 13) {
            if (this.state == 1) {
                ++this.tCounter;
                if (this.tCounter >= 30) {
                    this.setPhase(2);
                }
            } else if (this.state == 2) {
                for (n2 = 0; n2 < NewGame.gemCount; ++n2) {
                    if (GameItem.gameItems[NewGame.firstGem + n2].state > 7 || GameItem.gameItems[NewGame.firstGem + n2].state < 0 || !gameItems[NewGame.firstGem + n2].isAllive() || GameItem.gameItems[NewGame.firstGem + n2].myId == this.myId || GameItem.gameItems[NewGame.firstGem + n2].itemType >= 10 || !this.checkGemCollision(NewGame.firstGem + n2, -this.effRadius, -this.effRadius, this.effRadius, this.effRadius)) continue;
                    gameItems[NewGame.firstGem + n2].addEnergy(this.energyGain, false);
                }
            }
        }
        if (this.itemType == 19 && this.state == 5 && this.isAllive() && !this.sprite.isPlaying()) {
            this.sprite.visible = false;
            this.state = 6;
            ++NewGame.explosionCount;
            GameCommon.updateSoundEvnet(8);
            for (n2 = 0; n2 < NewGame.gemCount; ++n2) {
                if (!gameItems[NewGame.firstGem + n2].isAllive() || GameItem.gameItems[NewGame.firstGem + n2].myId == this.myId || GameItem.gameItems[NewGame.firstGem + n2].state < 0 || GameItem.gameItems[NewGame.firstGem + n2].itemType >= 10 && GameItem.gameItems[NewGame.firstGem + n2].itemType != 19 || !this.checkGemCollision(NewGame.firstGem + n2, -this.effRadius, -this.effRadius, this.effRadius, this.effRadius)) continue;
                if (GameItem.gameItems[NewGame.firstGem + n2].itemType == 19) {
                    gameItems[NewGame.firstGem + n2].addEnergy(this.mineDamage * GameItem.gameItems[NewGame.firstGem + n2].ppEnergy, false);
                    continue;
                }
                gameItems[NewGame.firstGem + n2].addEnergy((this.normalDamage + 1) * GameItem.gameItems[NewGame.firstGem + n2].ppEnergy, false);
                if (gameItems[NewGame.firstGem + n2].isMoving()) continue;
                gameItems[NewGame.firstGem + n2].setMoveDirectional(GameItem.gameItems[NewGame.firstGem + n2].posX - this.posX, GameItem.gameItems[NewGame.firstGem + n2].posY - this.posY);
                gameItems[NewGame.firstGem + n2].setVelocity(3, -1);
                GameItem.gameItems[NewGame.firstGem + n2].elastic = true;
            }
            for (n2 = 0; n2 < NewGame.creatureCount; ++n2) {
                if (!this.checkGemCollision(NewGame.creatures[n2].myId, -this.effRadius, -this.effRadius, this.effRadius, this.effRadius) || !NewGame.creatures[n2].isAllive() || NewGame.creatures[n2].itemType != 30 && NewGame.creatures[n2].itemType != 36 && NewGame.creatures[n2].itemType != 33) continue;
                NewGame.creatures[n2].hit(3);
            }
        }
        if (this.itemType == 18) {
            this.effRadius = 20;
            if (this.tCounter > 24) {
                ++this.tCounter;
                if (this.tCounter >= 34) {
                    this.tCounter = 0;
                }
            } else if (this.checkGemCollision(0, -this.effRadius, -this.effRadius, this.effRadius, this.effRadius)) {
                ++this.tCounter;
                n2 = gameItems[0].getDirectionX();
                n = gameItems[0].getDirectionY();
                int n3 = this.posX - GameItem.gameItems[0].posX;
                int n4 = this.posY - GameItem.gameItems[0].posY;
                gameItems[0].setMoveDirectional(n3 + n2, n4 + n);
            }
        }
        if (this.itemType == 15) {
            if (this.state == 1 && GameItem.gameItems[this.projectile].state == 0) {
                if (this.tCounter > 0) {
                    --this.tCounter;
                } else {
                    this.tCounter = 20;
                    GameItem.gameItems[this.projectile].posX = this.posX;
                    GameItem.gameItems[this.projectile].posY = this.posY;
                    gameItems[this.projectile].setVelocity(3, 0);
                    GameItem.gameItems[this.projectile].state = 1;
                    GameItem.gameItems[this.projectile].sprite.startPath(0);
                    GameItem.gameItems[this.projectile].sprite.visible = true;
                    n2 = Utils.randomInterval(0, 7);
                    switch (n2) {
                        case 0: {
                            gameItems[this.projectile].setMoveDirectional(0, 1);
                            this.sprite.startPath(1);
                            break;
                        }
                        case 1: {
                            gameItems[this.projectile].setMoveDirectional(-1, 0);
                            this.sprite.startPath(2);
                            break;
                        }
                        case 2: {
                            gameItems[this.projectile].setMoveDirectional(0, -1);
                            this.sprite.startPath(3);
                            break;
                        }
                        case 3: {
                            gameItems[this.projectile].setMoveDirectional(1, 0);
                            this.sprite.startPath(4);
                            break;
                        }
                        case 4: {
                            gameItems[this.projectile].setMoveDirectional(-1, 1);
                            this.sprite.startPath(5);
                            break;
                        }
                        case 5: {
                            gameItems[this.projectile].setMoveDirectional(1, 1);
                            this.sprite.startPath(6);
                            break;
                        }
                        case 6: {
                            gameItems[this.projectile].setMoveDirectional(-1, -1);
                            this.sprite.startPath(7);
                            break;
                        }
                        case 7: {
                            gameItems[this.projectile].setMoveDirectional(1, -1);
                            this.sprite.startPath(8);
                        }
                    }
                    gameItems[this.projectile].processMoveDirection();
                    gameItems[this.projectile].processMoveDirection();
                }
            } else if (GameItem.gameItems[this.projectile].state == 2 && !GameItem.gameItems[this.projectile].sprite.isPlaying()) {
                GameItem.gameItems[this.projectile].state = 0;
            }
        }
        if (this.itemType == 16 && this.data != -1) {
            if (NewGame.isBonusActive(262144)) {
                this.posX = gameItems[this.data].getX();
                this.posY = gameItems[this.data].getY();
            } else {
                this.sprite.visible = false;
                this.data = -1;
                this.state = -1;
            }
        }
        if (this.itemType == 20 && !this.isMoving() && NewGame.routerTargets[this.state] != null) {
            n2 = NewGame.routerTargets[this.state][0];
            this.setMove(NewGame.routerData[n2][1], NewGame.routerData[n2][2]);
            this.setVelocity(this.routerSpeed, 0);
            this.state = n2;
        }
        if (this.router > -1) {
            this.posX += GameItem.gameItems[3].progressX;
            this.posY += GameItem.gameItems[3].progressY;
            if (!this.isMoving() && NewGame.routerTargets[this.router] != null) {
                n2 = NewGame.routerTargets[this.router][0];
                this.setMove(NewGame.routerData[n2][1], NewGame.routerData[n2][2]);
                this.setVelocity(5, 0);
                this.router = n2;
            }
        }
        if (this.itemType < 10 && this.state == -1 && this.sprite != null && !this.sprite.isPlaying()) {
            n2 = this.sprite.getPlayPath();
            if (n2 == 8) {
                n = Utils.randomInterval(0, BreakConstants.bonusTable.length - 1);
                this.state = 9;
                this.sprite.startPath(this.state);
                this.myBonus = BreakConstants.bonusTable[n];
                if (NewGame.gameType == 0) {
                    this.setMoveDirectional(0, 1);
                    this.setVelocity(4, 0);
                } else {
                    n = Utils.randomInterval(0, 179);
                    this.setMoveDirectional(dirTable[n * 2], dirTable[n * 2 + 1]);
                    this.setVelocity(4, 0);
                }
            } else {
                this.state = 10;
            }
        }
        if (this.itemType < 10 && this.tarState != -1) {
            ++this.tarStateCount;
            if (this.tarStateCount >= 10) {
                if (this.state == 8) {
                    this.state = -1;
                    this.tarState = -1;
                    return;
                }
                this.tarStateCount = 0;
                ++this.state;
                this.sprite.startPath(this.state);
                System.out.println("State        : " + this.state);
                System.out.println("Target state : " + this.tarState);
                if (this.state == this.tarState) {
                    this.tarState = -1;
                }
            }
        }
        if (this.bounce != -1) {
            ++this.bounce;
        }
        if (this.explosion != -1) {
            ++this.explosion;
        }
    }

    public static GameItem addItem(int n, int n2, int n3, int n4, int n5, int n6) {
        return new GameItem(n, n2, n3, n4, n5, n6);
    }

    public void setMove(int n, int n2) {
        this.targetX = n;
        this.targetY = n2;
        this.origX = this.posX;
        this.origY = this.posY;
        this.directionX = this.targetX - this.posX;
        this.directionY = this.targetY - this.posY;
        int n3 = Utils.length(this.directionX, this.directionY);
        if (n3 == 0) {
            return;
        }
        this.directionXN = this.directionX * 100 / n3;
        this.directionYN = this.directionY * 100 / n3;
        this.progress = 0;
        this.moveState = 17;
    }

    public void setMoveDirectional(int n, int n2) {
        this.origX = this.posX;
        this.origY = this.posY;
        this.directionX = n;
        this.directionY = n2;
        int n3 = Utils.length(this.directionX, this.directionY);
        if (n3 == 0) {
            return;
        }
        this.directionXN = this.directionX * 100 / n3;
        this.directionYN = this.directionY * 100 / n3;
        this.moveState = 33;
    }

    public void setMoveDirectionalN(int n, int n2) {
        this.directionX = n;
        this.directionY = n2;
        this.directionXN = this.directionX * 100;
        this.directionYN = this.directionY * 100;
        this.moveState = 33;
    }

    public void invertDirection() {
        this.directionX *= -1;
        this.directionY *= -1;
        this.directionXN *= -1;
        this.directionYN *= -1;
    }

    public void stopItemMove() {
        this.moveState = 0;
    }

    public boolean isMoving() {
        return GameItem.flagUsed(this.moveState, 1);
    }

    protected void procesMove() {
        this.progress += this.velocity;
        int n = this.directionXN * this.progress / 100;
        int n2 = this.directionYN * this.progress / 100;
        if (Math.abs(this.directionX) < 2) {
            n = this.directionX;
        }
        if (Math.abs(this.directionY) < 2) {
            n2 = this.directionY;
        }
        if (Math.abs(n) >= Math.abs(this.directionX) && Math.abs(n2) >= Math.abs(this.directionY)) {
            this.posX = this.targetX;
            this.posY = this.targetY;
            this.finishMove();
            return;
        }
        this.posX = Math.abs(n) >= Math.abs(this.directionX) ? this.targetX : this.origX + n;
        this.posY = Math.abs(n2) >= Math.abs(this.directionY) ? this.targetY : this.origY + n2;
    }

    protected void processMoveDirection() {
        int n = this.directionXN * this.velocity / 100;
        int n2 = this.directionYN * this.velocity / 100;
        if (BreakConstants.DEBUG_PAD) {
            System.out.println("PM >> DirX : " + this.directionXN);
            System.out.println("PM >> DirY : " + this.directionYN);
        }
        this.posX += n;
        this.posY += n2;
        this.velocity += this.acceleration;
        if (this.velocity <= 0) {
            if (this.elastic) {
                this.elastic = false;
                this.velocity = 3;
                this.invertDirection();
            } else {
                this.velocity = 0;
                this.stopItemMove();
            }
        }
    }

    protected void draw() {
        if (!this.active) {
            return;
        }
        if (this.sprite != null && (this.itemType != 100 || this.state > 0)) {
            this.sprite.colorVariant = this.spriteColorVariant;
            this.sprite.paint(this.posX, this.posY);
        }
        if (this.bounce != -1) {
            NewGame.game.emitters[0].posX = this.bounceX;
            NewGame.game.emitters[0].posY = this.bounceY;
            if (NewGame.game.emitters[0].setState(this.bounce) != 0) {
                NewGame.game.emitters[0].draw();
            } else {
                this.bounce = -1;
            }
        }
        if (this.explosion != -1) {
            NewGame.game.emitters[1].posX = this.expX;
            NewGame.game.emitters[1].posY = this.expY;
            if (NewGame.game.emitters[1].setState(this.explosion) != 0) {
                NewGame.game.emitters[1].draw();
            } else {
                this.explosion = -1;
            }
        }
    }

    protected void finishMove() {
        this.moveState = 0;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getDirectionX() {
        return this.directionXN;
    }

    public int getDirectionY() {
        return this.directionYN;
    }

    public void setItemPosition(int n, int n2) {
        this.posX = n;
        this.posY = n2;
    }

    public void setVelocity(int n, int n2) {
        this.velocity = n;
        this.acceleration = n2;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setData(int n) {
        this.data = n;
    }

    public int getData() {
        return this.data;
    }

    public boolean isAllive() {
        if (!this.active) {
            return false;
        }
        if (this.itemType == 19) {
            return this.state != 6;
        }
        if (this.itemType == 16) {
            return this.state != -1;
        }
        return this.state != -1 && this.state != 10;
    }

    public void addEnergy(int n, boolean bl) {
        if (this.itemType == 11) {
            this.setPhase(1);
            return;
        }
        if (this.itemType == 12) {
            if (this.state == 0) {
                if (NewGame.gameType == 0) {
                    this.setMoveDirectional(0, NewGame.game.getPadMiddleY() - this.posY);
                } else {
                    this.setMoveDirectional(NewGame.game.getPadMiddleX() - this.posX, NewGame.game.getPadMiddleY() - this.posY);
                }
                this.setVelocity(3, 0);
                this.setPhase(2);
                this.transform();
            } else {
                this.setPhase(3);
            }
            return;
        }
        if (this.itemType == 13) {
            if (this.state == 0 || this.state == 3) {
                this.setPhase(1);
            } else if (this.state != 3) {
                this.setPhase(3);
            }
            return;
        }
        if (this.itemType == 16) {
            return;
        }
        if (this.itemType == 18) {
            return;
        }
        if (this.itemType == 15) {
            if (this.state == 0) {
                this.state = 1;
                this.sprite.startPath(0);
                this.tCounter = 20;
            } else {
                this.state = 0;
                this.sprite.startPath(10);
            }
            return;
        }
        if (this.itemType == 17) {
            return;
        }
        if (this.energy < 0) {
            return;
        }
        if (NewGame.ballDocked && !bl) {
            return;
        }
        if (!bl) {
            if (this.energyBuffer > 0) {
                this.energyBuffer += n;
                return;
            }
            if (n > this.ppEnergy) {
                this.energyBuffer = n - this.ppEnergy;
                n = this.ppEnergy;
                this.energyCounter = 4;
            }
        }
        int n2 = this.state;
        this.energy += n;
        if (this.energy < this.minEnergy) {
            this.energy = this.minEnergy;
        }
        this.state = this.energy / this.ppEnergy;
        if (this.itemType == 19) {
            if (this.state > 5) {
                this.state = 5;
            }
        } else if (this.state > 8) {
            this.state = 8;
        }
        if (this.state < 0) {
            this.state = 0;
        }
        if (n2 != this.state) {
            if (this.state == 8) {
                if (NewGame.colBonus < 3 && this.ghost == -1) {
                    int n3 = Utils.randomInterval(0, 100);
                    if (n3 < 20 && NewGame.extraGems != 0) {
                        int n4 = NewGame.firstGem + (NewGame.extraGems - 1);
                        GameItem.gameItems[n4].posX = this.posX;
                        GameItem.gameItems[n4].posY = this.posY;
                        GameItem.gameItems[n4].active = true;
                        --NewGame.extraGems;
                    }
                    if (n3 > 70) {
                        this.sprite.startPath(this.state);
                    } else {
                        this.sprite.startPath(11);
                    }
                } else {
                    this.sprite.startPath(11);
                }
            } else {
                this.sprite.startPath(this.state);
            }
            if (this.state == 8) {
                if (!this.exploded) {
                    this.explosion = 0;
                    this.expX = this.posX;
                    this.expY = this.posY;
                    this.exploded = true;
                    this.transform();
                }
                this.state = -1;
            }
        }
    }

    private void transform() {
        if (this.transformation != 0 && this.transIndex != 0) {
            if (this.transformation == 32 || this.transformation == 33 || this.transformation == 36 || this.transformation == 30) {
                NewGame.creatures[this.transIndex].posX = 30;
                NewGame.creatures[this.transIndex].posY = GameCommon.deskH_2;
                if (this.transformation == 30) {
                    NewGame.creatures[this.transIndex].sprite.startPath(5);
                } else if (this.transformation == 32) {
                    NewGame.creatures[this.transIndex].sprite.startPath(4);
                } else if (this.transformation == 33) {
                    NewGame.creatures[this.transIndex].sprite.startPath(3);
                } else if (this.transformation == 36) {
                    NewGame.creatures[this.transIndex].sprite.startPath(11);
                }
                NewGame.creatures[this.transIndex].enterState(5);
                GameCommon.updateSoundEvnet(7);
            } else {
                NewGame.creatures[this.transIndex].posX = this.posX;
                NewGame.creatures[this.transIndex].posY = this.posY;
                NewGame.creatures[this.transIndex].enterState(0);
                GameCommon.updateSoundEvnet(6);
                ++NewGame.createdGodCreatures;
            }
        }
    }

    public void setPhase(int n) {
        if (this.itemType == 13 && this.effRadius == 0) {
            this.effRadius = n;
            return;
        }
        if (this.itemType == 20) {
            this.state = n;
            this.posX = NewGame.routerData[this.state][1];
            this.posY = NewGame.routerData[this.state][2];
            this.lastX = this.posX;
            this.lastY = this.posY;
            return;
        }
        this.state = n;
        this.minEnergy = this.energy = n * this.ppEnergy;
        this.sprite.startPath(this.state);
        if (this.state == 8) {
            this.state = -1;
        }
    }

    public void setLives(int n) {
        if (this.itemType == 13 && this.energyGain == 0) {
            this.energyGain = n / 100;
        }
        if (this.itemType == 19) {
            this.lives = n;
            this.ppEnergy = this.lives / 5;
        } else {
            this.lives = n;
            this.ppEnergy = this.lives / 8;
        }
    }

    protected void actionPerformed(int n) {
    }

    protected boolean collides(int n) {
        if (this.itemType == 20) {
            return false;
        }
        if (n == 1) {
            if (this.itemType < 10 && this.state > 8) {
                return false;
            }
            if (this.itemType == 12 && this.state > 0) {
                return false;
            }
            if (this.itemType == 100) {
                return false;
            }
            return this.itemType != 19 || this.state < 5;
        }
        if (n == 0) {
            if (this.itemType == 12 && this.state == 2) {
                return true;
            }
            if (this.itemType < 10 && this.state > 8) {
                return true;
            }
            return this.itemType == 100 && this.state == 1;
        }
        return false;
    }

    public void setProjectile() {
    }

    public static boolean flagUsed(int n, int n2) {
        return (n & n2) > 0;
    }

    public int getState() {
        return this.state;
    }

    public void setOvercharge(int n) {
        this.overcharge = n;
    }

    public int getNextX() {
        return this.posX + this.getNextXM();
    }

    public int getNextY() {
        return this.posY + this.getNextYM();
    }

    public int getNextXM() {
        return this.directionXN * this.velocity / 100;
    }

    public int getNextYM() {
        return this.directionYN * this.velocity / 100;
    }

    public void setRouter(int n) {
        this.state = n;
        this.posX = NewGame.routerData[this.state][1];
        this.posY = NewGame.routerData[this.state][2];
    }

    public static boolean collide(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = OpenMathFP.toFP(GameItem.gameItems[n].posX);
        int n6 = OpenMathFP.toFP(GameItem.gameItems[n].posY);
        int n7 = OpenMathFP.toFP(GameItem.gameItems[n2].posX);
        int n8 = OpenMathFP.toFP(GameItem.gameItems[n2].posY);
        int n9 = OpenMathFP.toFP(GameItem.gameItems[n].radius);
        int n10 = OpenMathFP.toFP(GameItem.gameItems[n2].radius);
        int n11 = OpenMathFP.div(OpenMathFP.toFP(gameItems[n].getDirectionX()), OpenMathFP.toFP(100));
        int n12 = OpenMathFP.div(OpenMathFP.toFP(gameItems[n].getDirectionY()), OpenMathFP.toFP(100));
        int n13 = GameItem.distance(n5, n6, n7, n8);
        int n14 = n9 + n10;
        if (GameItem.gameItems[n2].itemType == 10) {
            return n13 < OpenMathFP.toFP(10);
        }
        int n15 = OpenMathFP.mul(n11, OpenMathFP.toFP(GameItem.gameItems[n].velocity));
        int n16 = GameItem.magnitude(n15, n4 = OpenMathFP.mul(n12, OpenMathFP.toFP(GameItem.gameItems[n].velocity)));
        if (n16 < (n13 -= n14)) {
            if (BreakConstants.DEBUG_GEM) {
                System.out.println("Early escape 1");
            }
            return false;
        }
        int n17 = n7 - n5;
        int n18 = n8 - n6;
        int n19 = GameItem.DOT(n17, n18, n11, n12);
        if (n19 <= OpenMathFP.toFP(0)) {
            if (BreakConstants.DEBUG_GEM) {
                System.out.println("DirX : " + GameItem.gameItems[n].directionX);
                System.out.println("DirY : " + GameItem.gameItems[n].directionY);
                System.out.println("Early escape 2");
            }
            return false;
        }
        int n20 = GameItem.magnitude(n17, n18);
        int n21 = OpenMathFP.mul(n20, n20) - OpenMathFP.mul(n19, n19);
        if (n21 >= (n3 = OpenMathFP.mul(n14, n14))) {
            return false;
        }
        int n22 = n3 - n21;
        if (n22 < 0) {
            return false;
        }
        int n23 = n19 - OpenMathFP.sqrt(n22);
        if (n16 < n23) {
            return false;
        }
        if (bl && (n13 < NewGame.colDistance || NewGame.colDistance == -1)) {
            NewGame.colDistance = n13;
            NewGame.lastGemCollision = n2;
            n11 = OpenMathFP.mul(n11, n23);
            n12 = OpenMathFP.mul(n12, n23);
            NewGame.colPosX = GameItem.gameItems[n].posX + OpenMathFP.toInt(n11);
            NewGame.colPosY = GameItem.gameItems[n].posY + OpenMathFP.toInt(n12);
        }
        if (GameItem.gameItems[n2].creature > -1) {
            gameItems[GameItem.gameItems[n2].creature].actionPerformed(GameItem.gameItems[n2].myId);
        }
        if (BreakConstants.DEBUG_COLLISIONS) {
            System.out.println("Collision with     : " + n2);
            System.out.println("Distance           : " + n13);
            System.out.println("--------------------------------------");
        }
        GameItem.gameItems[n2].bounce = 0;
        GameItem.gameItems[n2].bounceX = GameItem.gameItems[n2].posX + (GameItem.gameItems[n].posX - GameItem.gameItems[n2].posX) / 2;
        GameItem.gameItems[n2].bounceY = GameItem.gameItems[n2].posY + (GameItem.gameItems[n].posY - GameItem.gameItems[n2].posY) / 2;
        return true;
    }

    public static void bounceSpheres(int n, int n2) {
        int n3 = OpenMathFP.toFP(GameItem.gameItems[n].posX);
        int n4 = OpenMathFP.toFP(GameItem.gameItems[n].posY);
        int n5 = OpenMathFP.toFP(GameItem.gameItems[n2].posX + Utils.randomInterval(0, 2));
        int n6 = OpenMathFP.toFP(GameItem.gameItems[n2].posY + Utils.randomInterval(0, 2));
        int n7 = n3 - n5;
        int n8 = n4 - n6;
        int n9 = GameItem.magnitude(n7, n8);
        n7 = OpenMathFP.div(n7, n9);
        n8 = OpenMathFP.div(n8, n9);
        int n10 = OpenMathFP.div(OpenMathFP.toFP(gameItems[n].getDirectionX()), OpenMathFP.toFP(100));
        int n11 = OpenMathFP.div(OpenMathFP.toFP(gameItems[n].getDirectionY()), OpenMathFP.toFP(100));
        int n12 = OpenMathFP.mul(n10, OpenMathFP.toFP(GameItem.gameItems[n].velocity));
        int n13 = OpenMathFP.mul(n11, OpenMathFP.toFP(GameItem.gameItems[n].velocity));
        int n14 = GameItem.magnitude(n12, n13);
        n12 = OpenMathFP.div(n12, n14);
        n13 = OpenMathFP.div(n13, n14);
        int n15 = GameItem.DOT(n12, n13, n7, n8);
        int n16 = GameItem.DOT(OpenMathFP.toFP(0), OpenMathFP.toFP(0), n7, n8);
        int n17 = OpenMathFP.mul(n15 - n16, OpenMathFP.toFP(2));
        int n18 = OpenMathFP.mul(n12 - OpenMathFP.mul(n17, n7), OpenMathFP.toFP(100));
        int n19 = OpenMathFP.mul(n13 - OpenMathFP.mul(n17, n8), OpenMathFP.toFP(100));
        gameItems[n].setMoveDirectional(OpenMathFP.toInt(n18), OpenMathFP.toInt(n19));
    }

    public static int distance(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return OpenMathFP.sqrt(OpenMathFP.mul(n5, n5) + OpenMathFP.mul(n6, n6));
    }

    public static int magnitude(int n, int n2) {
        return OpenMathFP.sqrt(OpenMathFP.mul(n, n) + OpenMathFP.mul(n2, n2));
    }

    public static int DOT(int n, int n2, int n3, int n4) {
        return OpenMathFP.mul(n, n3) + OpenMathFP.mul(n2, n4);
    }

    protected boolean checkGemCollision(int n, int n2, int n3, int n4, int n5) {
        return Utils.intersectsBoxBox(this.posX + n2, this.posY + n3, this.posX + n4, this.posY + n5, gameItems[n].getX() + NewGame.gemCollX1, gameItems[n].getY() + NewGame.gemCollY1, gameItems[n].getX() + NewGame.gemCollX2, gameItems[n].getY() + NewGame.gemCollY2);
    }

    protected void genDirectionTable() {
        int n = OpenMathFP.toFP("0.035");
        int n2 = OpenMathFP.toFP(0);
        int n3 = OpenMathFP.toFP(0);
        int n4 = OpenMathFP.toFP(1);
        dirTable = new int[360];
        for (int i = 0; i < 180; ++i) {
            int n5 = OpenMathFP.sin(n2);
            int n6 = OpenMathFP.cos(n2);
            int n7 = OpenMathFP.mul(n3 - 0, n6) - OpenMathFP.mul(n4 - 0, n5);
            int n8 = OpenMathFP.mul(n3 - 0, n5) + OpenMathFP.mul(n4 - 0, n6);
            GameItem.dirTable[i * 2] = OpenMathFP.toInt(OpenMathFP.mul(n7, OpenMathFP.toFP(100)));
            GameItem.dirTable[i * 2 + 1] = OpenMathFP.toInt(OpenMathFP.mul(n8, OpenMathFP.toFP(100)));
            n2 += n;
        }
    }
}

